package polymorphicTypes;

public class ChurchEncodingSumExample {

	// This is a helper type.
	// In sofwtare engineering terminology, this is known as a "visitor",
	// (since the Church encoding is termed the "visitor pattern").
	interface K<A,B,R> {
		R case1(A a);
		R case2(B b);
	}
	
	// A sum type, Church-encoded
	interface Sum<A,B> {
		// <R> means "forall R."
		<R> R elim(K<A,B,R> k);
	}
	// The injections
	static class In1<A,B> implements Sum<A,B> {
		A a;
		In1(A a) {
			this.a = a;
		}
		@Override
		public <R> R elim(K<A,B,R> k) {
			return k.case1(a);
		}
	}
	static class In2<A,B> implements Sum<A,B> {
		B b;
		In2(B b) {
			this.b = b;
		}
		@Override
		public <R> R elim(K<A,B,R> k) {
			return k.case2(b);
		}
	}
	
	
	public static void main(String[] args) {
		// introduction
		Sum<Integer, String> s = new In1<>(4);
		Sum<Integer, String> t = new In2<>("shrdlu");
		
		// elimination
		String res;
		res = s.elim(new K<Integer, String, String>() {
			@Override
			public String case1(Integer i) {
				return "int: "+i;
			}
			@Override
			public String case2(String s) {
				return "string: "+s;
			}
		});
		System.out.println(res);
		res = t.elim(new K<Integer, String, String>() {
			@Override
			public String case1(Integer i) {
				return "int: "+i;
			}
			@Override
			public String case2(String s) {
				return "string: "+s;
			}
		});
		System.out.println(res);

	}

}
